import { h, Host } from '@stencil/core';
export class DiscordThread {
  constructor() {
    this.name = 'Thread';
    this.cta = 'See Thread';
  }
  render() {
    return (h(Host, { class: "discord-thread" }, h("div", { class: "discord-thread-top" }, h("span", { class: "discord-thread-name" }, this.name), h("span", { class: "discord-thread-cta", "aria-hidden": "true" }, this.cta, " \u203A")), h("span", { class: "discord-thread-bottom" }, h("slot", null))));
  }
  static get is() { return "discord-thread"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-thread.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-thread.css"]
    };
  }
  static get properties() {
    return {
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The name of the thread."
        },
        "attribute": "name",
        "reflect": false,
        "defaultValue": "'Thread'"
      },
      "cta": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The the text within the call to action text. (i.e. 'See Thread' or 'x Messages')"
        },
        "attribute": "cta",
        "reflect": false,
        "defaultValue": "'See Thread'"
      }
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-thread.js.map
