import { h, Host } from '@stencil/core';
export class DiscordSpoiler {
  constructor() {
    this.isRevealed = false;
  }
  reveal() {
    this.isRevealed = true;
  }
  render() {
    return (h(Host, { class: `discord-spoiler${this.isRevealed ? '--revealed' : ''}` }, h("slot", null)));
  }
  static get is() { return "discord-spoiler"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-spoiler.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-spoiler.css"]
    };
  }
  static get states() {
    return {
      "isRevealed": {}
    };
  }
  static get listeners() {
    return [{
        "name": "click",
        "method": "reveal",
        "target": undefined,
        "capture": false,
        "passive": false
      }];
  }
}
//# sourceMappingURL=discord-spoiler.js.map
