import { h, Host } from '@stencil/core';
import clsx from 'clsx';
import Fragment from '../../Fragment';
import { avatars, profiles } from '../../options';
import { handleTimestamp } from '../../util';
import { AuthorInfo } from '../author-info/author-info';
import Ephemeral from '../svgs/ephemeral';
export class DiscordMessage {
  constructor() {
    this.profile = undefined;
    this.author = 'User';
    this.avatar = undefined;
    this.bot = false;
    this.server = false;
    this.verified = false;
    this.op = false;
    this.edited = false;
    this.roleColor = undefined;
    this.roleIcon = undefined;
    this.roleName = undefined;
    this.highlight = false;
    this.ephemeral = false;
    this.timestamp = new Date();
    this.twentyFour = false;
  }
  updateTimestamp(value) {
    return handleTimestamp(value, this.twentyFour);
  }
  componentWillRender() {
    this.timestamp = handleTimestamp(this.timestamp, this.twentyFour);
  }
  render() {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
    const parent = this.el.parentElement;
    if (parent.tagName.toLowerCase() !== 'discord-messages') {
      throw new Error('All <discord-message> components must be direct children of <discord-messages>.');
    }
    const resolveAvatar = (avatar) => { var _a, _b; return (_b = (_a = avatars[avatar]) !== null && _a !== void 0 ? _a : avatar) !== null && _b !== void 0 ? _b : avatars.default; };
    const defaultData = {
      author: this.author,
      bot: this.bot,
      verified: this.verified,
      server: this.server,
      op: this.op,
      roleColor: this.roleColor,
      roleIcon: this.roleIcon,
      roleName: this.roleName
    };
    const profileData = (_a = Reflect.get(profiles, this.profile)) !== null && _a !== void 0 ? _a : {};
    const profile = Object.assign(Object.assign(Object.assign({}, defaultData), profileData), { avatar: resolveAvatar((_b = profileData.avatar) !== null && _b !== void 0 ? _b : this.avatar) });
    const highlightMention = 
    // @ts-expect-error ts doesn't understand this
    Array.from(this.el.children).some((child) => {
      return child.tagName.toLowerCase() === 'discord-mention' && child.highlight && ['user', 'role'].includes(child.type);
    }) || this.highlight;
    const hasThread = 
    // @ts-expect-error ts doesn't understand this
    Array.from(this.el.children).some((child) => {
      return child.tagName.toLowerCase() === 'discord-thread';
    });
    return (h(Host, { class: clsx('discord-message', {
        'discord-highlight-mention': highlightMention,
        'discord-message-has-thread': hasThread,
        'discord-highlight-ephemeral': this.ephemeral
      }) }, h("slot", { name: "reply" }), h("div", { class: "discord-message-inner" }, parent.compactMode && h("span", { class: "discord-message-timestamp" }, this.timestamp), h("div", { class: "discord-author-avatar" }, h("img", { src: profile.avatar, alt: profile.author })), h("div", { class: "discord-message-content" }, !parent.compactMode && (h(Fragment, null, h(AuthorInfo, { author: (_c = profile.author) !== null && _c !== void 0 ? _c : '', bot: (_d = profile.bot) !== null && _d !== void 0 ? _d : false, server: (_e = profile.server) !== null && _e !== void 0 ? _e : false, verified: (_f = profile.verified) !== null && _f !== void 0 ? _f : false, op: (_g = profile.op) !== null && _g !== void 0 ? _g : false, roleColor: (_h = profile.roleColor) !== null && _h !== void 0 ? _h : '', roleIcon: (_j = profile.roleIcon) !== null && _j !== void 0 ? _j : '', roleName: (_k = profile.roleName) !== null && _k !== void 0 ? _k : '', compact: parent.compactMode }), h("span", { class: "discord-message-timestamp" }, this.timestamp))), h("div", { class: "discord-message-body" }, parent.compactMode && (h(AuthorInfo, { author: (_l = profile.author) !== null && _l !== void 0 ? _l : '', bot: (_m = profile.bot) !== null && _m !== void 0 ? _m : false, server: (_o = profile.server) !== null && _o !== void 0 ? _o : false, verified: (_p = profile.verified) !== null && _p !== void 0 ? _p : false, op: (_q = profile.op) !== null && _q !== void 0 ? _q : false, roleColor: (_r = profile.roleColor) !== null && _r !== void 0 ? _r : '', roleIcon: (_s = profile.roleIcon) !== null && _s !== void 0 ? _s : '', roleName: (_t = profile.roleName) !== null && _t !== void 0 ? _t : '', compact: parent.compactMode })), h("span", { class: "discord-message-markup" }, h("slot", null)), this.edited ? h("span", { class: "discord-message-edited" }, "(edited)") : ''), h("div", { class: "discord-message-compact-indent" }, h("slot", { name: "embeds" }), h("slot", { name: "attachments" }), h("slot", { name: "components" }), h("slot", { name: "reactions" }), h("slot", { name: "thread" }), this.ephemeral && (h("div", { class: "discord-message-ephemeral" }, h(Ephemeral, { class: "discord-message-ephemeral-icon" }), "Only you can see this \u2022 ", h("span", { class: "discord-message-ephemeral-link" }, "Dismiss message"))))))));
  }
  static get is() { return "discord-message"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-message.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-message.css"]
    };
  }
  static get properties() {
    return {
      "profile": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The id of the profile data to use."
        },
        "attribute": "profile",
        "reflect": false
      },
      "author": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "'User'"
            }],
          "text": "The message author's username."
        },
        "attribute": "author",
        "reflect": false,
        "defaultValue": "'User'"
      },
      "avatar": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message author's avatar. Can be an avatar shortcut, relative path, or external link."
        },
        "attribute": "avatar",
        "reflect": false
      },
      "bot": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message author is a bot or not.\nOnly works if `server` is `false` or `undefined`."
        },
        "attribute": "bot",
        "reflect": false,
        "defaultValue": "false"
      },
      "server": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message author is a server crosspost webhook or not.\nOnly works if `bot` is `false` or `undefined`."
        },
        "attribute": "server",
        "reflect": false,
        "defaultValue": "false"
      },
      "verified": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the bot is verified or not.\nOnly works if `bot` is `true`"
        },
        "attribute": "verified",
        "reflect": false,
        "defaultValue": "false"
      },
      "op": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the author is the original poster."
        },
        "attribute": "op",
        "reflect": false,
        "defaultValue": "false"
      },
      "edited": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether the message has been edited or not."
        },
        "attribute": "edited",
        "reflect": false,
        "defaultValue": "false"
      },
      "roleColor": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message author's primary role color. Can be any [CSS color value](https://www.w3schools.com/cssref/css_colors_legal.asp)."
        },
        "attribute": "role-color",
        "reflect": false
      },
      "roleIcon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The message author's role icon URL."
        },
        "attribute": "role-icon",
        "reflect": false
      },
      "roleName": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The name of the role to use as alternative image text."
        },
        "attribute": "role-name",
        "reflect": false
      },
      "highlight": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether to highlight this message."
        },
        "attribute": "highlight",
        "reflect": false,
        "defaultValue": "false"
      },
      "ephemeral": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether to make this message ephemeral."
        },
        "attribute": "ephemeral",
        "reflect": false,
        "defaultValue": "false"
      },
      "timestamp": {
        "type": "string",
        "mutable": true,
        "complexType": {
          "original": "DiscordTimestamp",
          "resolved": "Date | null | string",
          "references": {
            "DiscordTimestamp": {
              "location": "import",
              "path": "../../util"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The timestamp to use for the message date."
        },
        "attribute": "timestamp",
        "reflect": true,
        "defaultValue": "new Date()"
      },
      "twentyFour": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Whether to use 24-hour format for the timestamp."
        },
        "attribute": "twenty-four",
        "reflect": false,
        "defaultValue": "false"
      }
    };
  }
  static get elementRef() { return "el"; }
  static get watchers() {
    return [{
        "propName": "timestamp",
        "methodName": "updateTimestamp"
      }];
  }
}
//# sourceMappingURL=discord-message.js.map
