import { h } from '@stencil/core';
import clsx from 'clsx';
import Fragment from '../../Fragment';
import { getGlobalEmojiUrl } from '../../util';
export class DiscordEmbed {
  constructor() {
    this.hasPerformedRerenderChecks = 'pristine';
    this.color = undefined;
    this.authorName = undefined;
    this.authorImage = undefined;
    this.authorUrl = undefined;
    this.embedTitle = undefined;
    this.url = undefined;
    this.thumbnail = undefined;
    this.image = undefined;
    this.video = undefined;
    this.provider = undefined;
    this.hasProvidedDescriptionSlot = true;
  }
  componentDidRender() {
    if (this.hasPerformedRerenderChecks === 'pristine') {
      try {
        const discordEmbedDescriptionChild = this.el.querySelector('.discord-embed-description');
        this.hasProvidedDescriptionSlot = Boolean(discordEmbedDescriptionChild === null || discordEmbedDescriptionChild === void 0 ? void 0 : discordEmbedDescriptionChild.innerHTML.trim());
      }
      finally {
        this.hasPerformedRerenderChecks = 'dirty';
      }
    }
  }
  render() {
    const emojiParsedAuthorName = this.parseTitle(this.authorName);
    const emojiParsedEmbedTitle = this.parseTitle(this.embedTitle);
    return (h("div", { class: "discord-embed" }, h("div", { style: { 'background-color': this.color }, class: "discord-left-border" }), h("div", { class: "discord-embed-root" }, h("div", { class: "discord-embed-wrapper" }, h("div", { class: "discord-embed-grid" }, this.provider && (h("div", { class: "discord-embed-provider" }, h(Fragment, null, this.provider))), emojiParsedAuthorName && (h("div", { class: "discord-embed-author" }, this.authorImage ? h("img", { src: this.authorImage, alt: "", class: "discord-author-image" }) : '', this.authorUrl ? (h("a", { href: this.authorUrl, target: "_blank", rel: "noopener noreferrer" }, ...emojiParsedAuthorName)) : (h(Fragment, null, ...emojiParsedAuthorName)))), emojiParsedEmbedTitle && (h("div", { class: "discord-embed-title" }, this.url ? (h("a", { href: this.url, target: "_blank", rel: "noopener noreferrer" }, ...emojiParsedEmbedTitle)) : (h(Fragment, null, ...emojiParsedEmbedTitle)))), this.hasProvidedDescriptionSlot && h("slot", { name: "description" }), h("slot", { name: "fields" }), this.image || this.video ? (h("div", { class: clsx('discord-embed-media', { 'discord-embed-media-video': Boolean(this.video) }) }, this.renderMedia())) : null, this.thumbnail ? h("img", { src: this.thumbnail, alt: "", class: "discord-embed-thumbnail" }) : '', h("slot", { name: "footer" }))))));
  }
  renderMedia() {
    if (this.video) {
      return (h("video", { controls: true, muted: true, preload: "none", poster: this.image, src: this.video, height: "225", width: "400", class: "discord-embed-video" }, h("img", { src: this.image, alt: "Discord embed media", class: "discord-embed-image" })));
    }
    else if (this.image) {
      return h("img", { src: this.image, alt: "Discord embed media", class: "discord-embed-image" });
    }
    return null;
  }
  parseTitle(title) {
    if (!title)
      return null;
    const words = title.split(' ');
    return words.map((word, idx) => {
      var _a;
      const emoji = (_a = getGlobalEmojiUrl(word)) !== null && _a !== void 0 ? _a : {};
      let el = '';
      if (emoji.name) {
        el = (h("span", { class: "discord-embed-custom-emoji" }, h("img", { src: emoji.url, alt: emoji.name, class: "discord-embed-custom-emoji-image" }), h("span", null, "\u00A0")));
      }
      else {
        el = idx < words.length - 1 ? `${word} ` : word;
      }
      return el;
    });
  }
  static get is() { return "discord-embed"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-embed.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-embed.css"]
    };
  }
  static get properties() {
    return {
      "color": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The color to use for the embed's left border. Can be any [CSS color value](https://www.w3schools.com/cssref/css_colors_legal.asp)."
        },
        "attribute": "color",
        "reflect": false
      },
      "authorName": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The author's name."
        },
        "attribute": "author-name",
        "reflect": false
      },
      "authorImage": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The author's avatar URL."
        },
        "attribute": "author-image",
        "reflect": false
      },
      "authorUrl": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The URL to open when you click on the author's name."
        },
        "attribute": "author-url",
        "reflect": false
      },
      "embedTitle": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The embed title."
        },
        "attribute": "embed-title",
        "reflect": false
      },
      "url": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The URL to open when you click on the embed title."
        },
        "attribute": "url",
        "reflect": false
      },
      "thumbnail": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The thumbnail image to use."
        },
        "attribute": "thumbnail",
        "reflect": false
      },
      "image": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The embed image to use (displayed at the bottom)."
        },
        "attribute": "image",
        "reflect": false
      },
      "video": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "important",
              "text": "YouTube videos will not be playable on your projects, this is due to YouTube using DASH to play their videos rather\nthan providing the raw media stream (in a container such as mp4 or ogg). Links to regular MP4 files (such as on a CDN) however\nwill autoplay!"
            }, {
              "name": "note",
              "text": "Video takes priority over image."
            }, {
              "name": "remark",
              "text": "Providing both a video and an image will ensure the image is shown to users with browsers\nthat do not support HTML5 video playback."
            }, {
              "name": "example",
              "text": "https://download.blender.org/peach/bigbuckbunny_movies/big_buck_bunny_1080p_stereo.ogg"
            }],
          "text": "The embed video to use (displayed at the bottom, same slot as the image)."
        },
        "attribute": "video",
        "reflect": false
      },
      "provider": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "example",
              "text": "YouTube"
            }],
          "text": "The provider to show above the embed, for example for YouTube videos it will show \"YouTube\" at the top of the embed (above the author)"
        },
        "attribute": "provider",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "hasProvidedDescriptionSlot": {}
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-embed.js.map
