import { h, Host } from '@stencil/core';
import Fragment from '../../Fragment';
import { handleTimestamp } from '../../util';
export class DiscordEmbedFooter {
  constructor() {
    this.footerImage = undefined;
    this.timestamp = undefined;
  }
  updateTimestamp(value) {
    if (!value || isNaN(new Date(value).getTime()))
      return null;
    return handleTimestamp(new Date(value));
  }
  componentWillRender() {
    this.timestamp = this.updateTimestamp(this.timestamp);
  }
  render() {
    const parent = this.el.parentElement;
    if (parent.tagName.toLowerCase() !== 'div') {
      throw new Error('All <discord-embed-footer> components must be direct children of <discord-embed>.');
    }
    return (h(Host, { class: "discord-embed-footer" }, this.footerImage ? h("img", { src: this.footerImage, alt: "", class: "discord-footer-image" }) : '', h(Fragment, null, h("slot", null), this.timestamp ? h("span", { class: "discord-footer-separator" }, "\u2022") : '', this.timestamp ? h(Fragment, null, this.timestamp) : '')));
  }
  static get is() { return "discord-embed-footer"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-embed-footer.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-embed-footer.css"]
    };
  }
  static get properties() {
    return {
      "footerImage": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The image to use next to the footer text."
        },
        "attribute": "footer-image",
        "reflect": false
      },
      "timestamp": {
        "type": "string",
        "mutable": true,
        "complexType": {
          "original": "DiscordTimestamp",
          "resolved": "Date | null | string | undefined",
          "references": {
            "DiscordTimestamp": {
              "location": "import",
              "path": "../../util"
            }
          }
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [],
          "text": "The timestamp to use for the message date. When supplying a string, the format must be `01/31/2000`."
        },
        "attribute": "timestamp",
        "reflect": true
      }
    };
  }
  static get elementRef() { return "el"; }
  static get watchers() {
    return [{
        "propName": "timestamp",
        "methodName": "updateTimestamp"
      }];
  }
}
//# sourceMappingURL=discord-embed-footer.js.map
