import { h, Host } from '@stencil/core';
export class DiscordEmbedDescription {
  render() {
    const parent = this.el.parentElement;
    if (parent.tagName.toLowerCase() !== 'div') {
      throw new Error('All <discord-embed-description> components must be direct children of <discord-embed>.');
    }
    return (h(Host, { class: "discord-embed-description" }, h("slot", null)));
  }
  static get is() { return "discord-embed-description"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-embed-description.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-embed-description.css"]
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-embed-description.js.map
