import { h, Host } from '@stencil/core';
var DiscordAttachmentType;
(function (DiscordAttachmentType) {
  DiscordAttachmentType["IMAGE"] = "image";
  DiscordAttachmentType["VIDEO"] = "video";
  DiscordAttachmentType["AUDIO"] = "audio";
  DiscordAttachmentType["FILE"] = "file";
})(DiscordAttachmentType || (DiscordAttachmentType = {}));
export class DiscordAttachment {
  constructor() {
    this.url = undefined;
    this.type = undefined;
    this.size = undefined;
    this.height = undefined;
    this.width = undefined;
    this.alt = 'discord attachment';
  }
  render() {
    switch (this.type) {
      case DiscordAttachmentType.IMAGE:
        return (h(Host, { class: "discord-attachment" }, h("div", { class: "discord-image-wrapper" }, h("img", { alt: this.alt, src: this.url, height: this.height, width: this.width }))));
      case DiscordAttachmentType.VIDEO:
        return (h(Host, { class: "discord-attachment" }, h("div", { class: "discord-image-wrapper" }, h("video", { src: this.url, height: this.height, width: this.width, controls: true }))));
      case DiscordAttachmentType.AUDIO:
        return (h(Host, { class: "discord-attachment" }, h("audio", { src: this.url })));
      case DiscordAttachmentType.FILE:
      default:
        return (h(Host, { class: "discord-attachment-generic" }, h("div", { class: "discord-attachment-generic-icon" }, h("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", height: "96", viewBox: "0 0 72 96", width: "72" }, h("path", { d: "m72 29.3v60.3c0 2.24 0 3.36-.44 4.22-.38.74-1 1.36-1.74 1.74-.86.44-1.98.44-4.22.44h-59.2c-2.24 0-3.36 0-4.22-.44-.74-.38-1.36-1-1.74-1.74-.44-.86-.44-1.98-.44-4.22v-83.2c0-2.24 0-3.36.44-4.22.38-.74 1-1.36 1.74-1.74.86-.44 1.98-.44 4.22-.44h36.3c1.96 0 2.94 0 3.86.22.5.12.98.28 1.44.5v16.88c0 2.24 0 3.36.44 4.22.38.74 1 1.36 1.74 1.74.86.44 1.98.44 4.22.44h16.88c.22.46.38.94.5 1.44.22.92.22 1.9.22 3.86z", fill: "#d3d6fd" }), h("path", { d: "m68.26 20.26c1.38 1.38 2.06 2.06 2.56 2.88.18.28.32.56.46.86h-16.88c-2.24 0-3.36 0-4.22-.44-.74-.38-1.36-1-1.74-1.74-.44-.86-.44-1.98-.44-4.22v-16.880029c.3.14.58.28.86.459999.82.5 1.5 1.18 2.88 2.56z", fill: "#939bf9" }))), h("div", { class: "discord-attachment-generic-inner" }, h("div", { class: "discord-attachment-generic-name" }, h("a", { href: this.url, target: "_blank", rel: "noopener noreferrer" }, this.alt)), h("div", { class: "discord-attachment-generic-size" }, this.size)), h("div", { class: "discord-attachment-generic-download" }, h("a", { href: this.url, download: true }, h("svg", { "aria-hidden": "true", role: "img", width: "24", height: "24", viewBox: "0 0 24 24" }, h("path", { fill: "currentColor", "fill-rule": "evenodd", "clip-rule": "evenodd", d: "M16.293 9.293L17.707 10.707L12 16.414L6.29297 10.707L7.70697 9.293L11 12.586V2H13V12.586L16.293 9.293ZM18 20V18H20V20C20 21.102 19.104 22 18 22H6C4.896 22 4 21.102 4 20V18H6V20H18Z" }))))));
    }
  }
  static get is() { return "discord-attachment"; }
  static get originalStyleUrls() {
    return {
      "$": ["discord-attachment.css"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["discord-attachment.css"]
    };
  }
  static get properties() {
    return {
      "url": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "important",
              "text": "Should be a valid image URL, i.e. matching the regex `/\\.(bmp|jpe?g|png|gif|webp|tiff)$/i`"
            }],
          "text": "The URL for the image attachment"
        },
        "attribute": "url",
        "reflect": false
      },
      "type": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "'image' | 'video' | 'audio' | 'file'",
          "resolved": "\"audio\" | \"file\" | \"image\" | \"video\"",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The type of file the attachment is.\n'image' | 'video' | 'audio' | 'file'"
        },
        "attribute": "type",
        "reflect": false
      },
      "size": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "The size of the file."
        },
        "attribute": "size",
        "reflect": false
      },
      "height": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number | undefined",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [],
          "text": "The height of the image in pixels"
        },
        "attribute": "height",
        "reflect": false
      },
      "width": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number | undefined",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [],
          "text": "The width of the image in pixels"
        },
        "attribute": "width",
        "reflect": false
      },
      "alt": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string | undefined",
          "resolved": "string | undefined",
          "references": {}
        },
        "required": false,
        "optional": true,
        "docs": {
          "tags": [{
              "name": "default",
              "text": "'discord attachment'"
            }],
          "text": "The alt text to show in case the image was unable to load"
        },
        "attribute": "alt",
        "reflect": false,
        "defaultValue": "'discord attachment'"
      }
    };
  }
  static get elementRef() { return "el"; }
}
//# sourceMappingURL=discord-attachment.js.map
